/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package applicationIO;

import java.io.Closeable;

/**
 *
 * @author Matthew Gregory
 */
public interface Output extends Closeable {
    //Methods to write a string to our internal buffer.
    public void write(String input);
    public void writeln(String input);
    
    //Methods to write an object to our internal buffer.
    //Defaults to converting the object to a string an then writing the string.
    default public void write(Object input){
        write(input.toString());
    };
    default public void writeln(Object input){
        writeln(input.toString());
    };
    //Writeln method with no parameters.  Defaults to simple writing a new line.
    default public void writeln(){
        writeln("");
    }
    
    //Methods to generate the final output.
    public void close();
}
